if(typeof swt == "undefined"){
(function(){
	if(typeof this["swt"] == "undefined"){
		this.swt = {};
	}
	
	swt.copyBounds = function(newDim,oldDim){
		oldDim = oldDim || {};
		newDim.l = newDim.l || oldDim.l || 0;
		newDim.t = newDim.t || oldDim.t || 0;
		newDim.w = newDim.w || oldDim.w || 0;
		newDim.h = newDim.h || oldDim.h || 0;
		return newDim;
	}
	
	swt.getNativeBounds = function(node, keepCurrentStyle){
		var computedDim = {};
		dojo.mixin(computedDim, swt.getNativeLocation(node));
		dojo.mixin(computedDim, swt.getNativeSize(node, keepCurrentStyle));
		return computedDim;
	}
	
	swt.getNativeLocation = function(node){
		var computedLocation = {};
		computedLocation.l = node.clientLeft || dojo.style(node,"left");
		computedLocation.t = node.clientTop || dojo.style(node,"top");
		return computedLocation;
	}
	
	swt.getNativeSize = function(node, keepCurrentStyle){
		var computedSize = {};
		if (!keepCurrentStyle){
			node = dojo.clone(node);
			if (node.tagName == "INPUT" && node.type == "text") {
				var tmpNode = document.createElement("div");
//TODO clone attributes				
//				for (i=0;i<node.attributes.length;i++) {
//					tmpNode.attributes[i]=node.attributes[i];
//				}
				tmpNode.innerHTML = node.value == "" ? "E" : node.value;
				node = tmpNode;
			}
			swt.setCssStyle(node,{
				position: "fixed",
				visibility: "hidden"
			});
			dojo.place(node, dojo.body(), "last");
			swt._setDim(node,{t:null,l:null,w:null,h:null});
	    	swt.setCssStyle(node,{
				display: 	"inline",
				overflowX: 	"visible",
		    	overflowY: 	"visible"
			});
		}

		computedSize.w = node.offsetWidth || dojo.style(node,"width");
		computedSize.h = node.offsetHeight || dojo.style(node,"height");
		
		if (!keepCurrentStyle){
			dojo._destroyElement(node);
		}
		return computedSize;
	}
	
	swt.getComputedBounds = function(node,params){
		var dim = swt.getNativeBounds(node);
		swt._checkParameters(dim,params);
		return dim;
	}
	
	swt._checkParameters = function(dim,params){
		if (params) {
			dim.w = swt._checkMin(dim.w,params.minWidth);
			dim.w = swt._checkMax(dim.w,params.maxWidth);
			dim.h = swt._checkMin(dim.h,params.minHeight);
			dim.h = swt._checkMax(dim.h,params.maxHeight);
		}
	}
	
	swt._checkMin = function(value,minValue){
		var newValue = value<minValue ? minValue : value;
		return newValue>0 ? newValue : 0;
	}
	
	swt._checkMax = function(value,maxValue){
		var newValue = value>maxValue ? maxValue : value;
		return newValue>0 ? newValue : 0;
	}
	
	swt._setDim = function(node,dim){
		node.style.left = dim.l;
		node.style.top = dim.t;
		node.style.width = dim.w;
		node.style.height = dim.h;
		return dim;
	}
	
	swt.getPosition = function(node) {
		var x = y = 0;
		if (node.offsetParent) {
			do {
				x += node.offsetLeft;
				y += node.offsetTop;
			} 
			while (node = node.offsetParent);
		}
		return {x: x, y: y};
	}
	
	swt.isConectedToBody = function(node) {
    	return swt._isConectedToBody(node, false);
    }
        
    swt._isConectedToBody = function(node, connected) {
    	if (node) {
    		if (node.parentNode) {
        		if (node.parentNode == document.body) {
        			return true; 
        		} else {
        			return swt._isConectedToBody(node.parentNode, connected);
        		}
    		} else if (node == document.body) {
    			return true;
    		} else {
    			return false;
    		}
    	} else {
    		return false;
    	}
    }
    
    var isPixelised = {
    	backgroundPosition: true,
		fontSize: true,
		height: true, 
		left: true, 
		top: true,
		width: true 
	};
    
    swt.setCssStyle = function(node, cssObject, isPxValue){
    	for(style in cssObject) {
    		dojo.style(
    			node, 
				style, 
	    		(!isPixelised[style] || cssObject[style]=="" || isNaN(cssObject[style])) ? cssObject[style] : cssObject[style] + "px"
			);
		}
	}
    
    swt.setNativeBounds = function(node, dim){
		var newDim = {};
		newDim.l = dim.l>=0 ? dim.l : "NaN";
		newDim.t = dim.t>=0 ? dim.t : "NaN";
		newDim.w = dim.w>=0 ? dim.w : -1;
		newDim.h = dim.h>=0 ? dim.h : -1;
		dojo._setBox(node, newDim.l, newDim.t, newDim.w, newDim.h);
		return newDim;
	}
	
	swt.setBounds = function(node, dim, ignoreExtents){
		var newDim = dojo.mixin({}, dim);
		if (!ignoreExtents) {
			var	padBorder = (node.tagName!="TABLE") ? dojo._getPadBorderExtents(node) : {w:0,h:0};
			if(dim.h>=0){
				newDim.h = Math.max(dim.h - padBorder.h, 0);
			}
			if(dim.w>=0){ 
				newDim.w = Math.max(dim.w - padBorder.w, 0); 
			}
		}
		return swt.setNativeBounds(node, newDim);
	}
	
})();
}